IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CF_BancoCabal_TX]') 
                   and [type] = 'FN')
BEGIN
    DROP FUNCTION [dbo].[CF_BancoCabal_TX] 
END
GO

CREATE FUNCTION [dbo].[CF_BancoCabal_TX](@pId_Trans INT, @pImporte DECIMAL(12,2), @pId_Tar_Lote INT) 
RETURNS CHAR(240)
AS
BEGIN

/*Variable de Retorno*/
DECLARE @Retorno			CHAR(240)
/*FIN Variable de Retorno*/

/*Variables del Archivo*/
DECLARE @aId_Trans		CHAR(9)/*DESCRIPCIÓN: Descripcion del Archivo para esta campo: Identificación del socio, PERO EN CLEVER NECESITAMOS EL ID_TRANS PARA PODER IDENTIFICAR LA TRANSACCIÓN EN EL ARCHIVO DE RESPUESTA. POS: 001-009. LONG: 9. FORMATO: Numérico. OBS: Número con el que la Empresa identifica a su cliente/socio.*/
DECLARE @aTar_Nro		CHAR(16)/*DESCRIPCIÓN: Número de Tarjeta Cabal. POS: 010-025. LONG: 16. FORMATO: Numérico. OBS: IMPORTANTE: actualizar el dato con lo informado en el archivo de respuesta.*/
DECLARE @aImporte		CHAR(11)/*DESCRIPCIÓN: Importe del Débito. POS: 026-036. LONG: 11. FORMATO: Numérico. OBS: Formato: 9 enteros con 2 decimales, sin usar separador decimal.*/
DECLARE @aLibreA		CHAR(82)/*DESCRIPCIÓN: Libre. POS: 037-118. LONG: 82. FORMATO: Alfanumérico. OBS: Completar con espacios.*/
DECLARE @aDescripcion	CHAR(25)/*DESCRIPCIÓN: Leyenda que se imprime en el resumen del usuario. Compañías de Seguro: Nombre de la Aseguradora Rama '/' (informar barra) Número de Póliza '/' (informar barra) Endoso '/' (informar barra) Número de Cuota. POS: 119-143. LONG: 25 (7,2,1,8,1,3,1,2). FORMATO: Alfanumérico. OBS: Si no se informa, se toma el Nombre del Comercio.*/
DECLARE @aFechaPresent	CHAR(6)/*DESCRIPCIÓN: Fecha de la Presentación. POS: 144-149. LONG: 6. FORMATO: Numérico. OBS: Formato: DDMMAA.*/
DECLARE @aLibreB		CHAR(27)/*DESCRIPCIÓN: Libre. POS: 150-176. LONG: 27. FORMATO: Alfanumérico. OBS: Completar con espacios.*/
DECLARE @aNroComercio	CHAR(11)/*DESCRIPCIÓN: Número de Comercio Cabal. POS: 177-187. LONG: 11. FORMATO: Numérico. OBS: */
DECLARE @aId_Moneda		CHAR(1)/*DESCRIPCIÓN: Código de Moneda. POS: 188-188. LONG: 1. FORMATO: Alfanumérico. OBS: Informar: 'P'*/
DECLARE @aLibreC		CHAR(21)/*DESCRIPCIÓN: Libre. POS: 189-209. LONG: 21. FORMATO: Alfanumérico. OBS: Completar con espacios.*/
DECLARE @aNroTicket		CHAR(4)/*DESCRIPCIÓN: Número de Ticket. POS: 210-213. LONG: 4. FORMATO: Numérico. OBS: No debe repetirse dentro de la misma presentación.*/
DECLARE @aLibreD		CHAR(10)/*DESCRIPCIÓN: Libre. POS: 214-223. LONG: 10. FORMATO: Alfanumérico. OBS: Completar con espacios.*/
DECLARE @aCodOperacion	CHAR(2)/*DESCRIPCIÓN: Código de Operación. POS: 224-225. LONG: 2. FORMATO: Numérico. OBS: '01': Débito al Usuario / '51': Crédito al Usuario*/
DECLARE @aLibreE		CHAR(15)/*DESCRIPCIÓN: Libre. POS: 226-240. LONG: 15. FORMATO: Alfanumérico. OBS: Completar con espacios.*/
/*FIN Variables del Archivo*/

/*Variables Intermedias*/
DECLARE @Tar_Nro				VARCHAR(22)
DECLARE @Fecha_Cbte				DATETIME
DECLARE @Anio_Periodo			VARCHAR(4)
DECLARE @Mes_Periodo			VARCHAR(2)
DECLARE @Fecha_Presentacion		DATETIME
DECLARE @Id_Tarjeta				VARCHAR(10)
DECLARE @Comercio_Nro			VARCHAR(50)
DECLARE @Item					INT
/*FIN Variables Intermedias*/

/*Calculos intermerdios*/
SELECT	@Fecha_Presentacion = ISNULL(Fecha_Presentacion, '19000101'),
		@Id_Tarjeta			= ISNULL(Id_Tarjeta, '')
FROM Val_Tarjetas_Lotes
WHERE
Id_Tar_Lote = @pId_Tar_Lote


SELECT	@Tar_Nro		= ISNULL(Nro, ''),
		@Item			= ISNULL(Item, 0)
FROM Val_Tarjetas_Lotes_Items 
WHERE
Id_Tar_Lote = @pId_Tar_Lote
AND Id_Trans = @pId_Trans


SELECT  @Fecha_Cbte		= ISNULL(Fecha, '19000101')
FROM Cbtes
WHERE 
Id_Trans = @pId_Trans

SET @Anio_Periodo = CAST(DATEPART(YY,@Fecha_Cbte) AS CHAR(4))
SET @Mes_Periodo = RIGHT('00' + CAST(MONTH(@Fecha_Cbte) AS VARCHAR),2)

SELECT @Comercio_Nro = ISNULL(Comercio_Nro, '')
FROM Valores_Tarjetas_Cred
WHERE
Id_Tarjeta = @Id_Tarjeta
/*FIN Calculos intermerdios*/

/*=============================================================================*/

/*Grabacion de los campos de la fila*/
SET @aId_Trans		= RIGHT('000000000' + CAST(@pId_Trans AS VARCHAR), 9)
SET @aTar_Nro		= RIGHT('0000000000000000000000' + @Tar_Nro, 16)
SET @aImporte		= RIGHT('00000000000' + CAST(CAST(@pImporte * 100 AS INT) AS VARCHAR), 11)
SET @aLibreA		= '                                                                                  '
SET @aDescripcion	= 'CUOTA MES: ' + @Anio_Periodo + '/' + @Mes_Periodo
SET @aFechaPresent	= RIGHT('00' + CAST(DAY(@Fecha_Presentacion) AS VARCHAR),2) + RIGHT('00' + CAST(MONTH(@Fecha_Presentacion) AS VARCHAR),2) + SUBSTRING(CAST(DATEPART(YY, @Fecha_Presentacion) AS CHAR(4)),3,2)
SET @aLibreB		= '                           '
SET @aNroComercio	= RIGHT('00000000000' + CAST(@Comercio_Nro AS VARCHAR), 11)
SET @aId_Moneda		= 'P'
SET @aLibreC		= '                     '
SET @aNroTicket		= RIGHT('0000' + CAST(@Item AS VARCHAR), 4)
SET @aLibreD		= '          '
SET @aCodOperacion	= '01' /*01 débito al usuario. 51 es para credito*/
SET @aLibreE		= '               '
/*FIN Grabacion de los campos de la fila*/

/*=============================================================================*/

/*Grabación de la Fila Completa*/
SET @Retorno			=	@aId_Trans		+
							@aTar_Nro		+
							@aImporte		+
							@aLibreA		+
							@aDescripcion	+
							@aFechaPresent	+
							@aLibreB		+
							@aNroComercio	+
							@aId_Moneda		+
							@aLibreC		+
							@aNroTicket		+
							@aLibreD		+
							@aCodOperacion	+
							@aLibreE
/*FIN Grabación de la Fila Completa*/

RETURN ISNULL(@Retorno, '')
END